package S2::FW;
use Mojo::Base 'Mojolicious', -signatures;

use Mojo::File qw/curfile/;
use Mojo::Home;
use S2::FW::Plugin::BasicAuth;
use S2::FW::Plugin::Iftop;
use S2::FW::Plugin::NFT;

our $VERSION = '2.0';

sub startup ($self) {
    $self->moniker('s2fw');
    my $conffile = '/etc/' . $self->moniker . '.conf';
    my $config   = $self->plugin('Config',
        file => -e $conffile ? $conffile : undef
    );

    $self->home(Mojo::Home->new(curfile->sibling('FW')));
    $self->static->paths->[0]   = $self->home->child('public');
    $self->renderer->paths->[0] = $self->home->child('templates');

    $self->secrets($config->{secrets});
    $self->commands->namespaces(['Mojolicious::Command', 'S2::FW::Command']);

    $self->plugin('S2::FW::Plugin::BasicAuth');
    $self->plugin('S2::FW::Plugin::Iftop');
    $self->plugin('S2::FW::Plugin::NFT');

    my $r = $self->routes->under(sub ($c) {
            return unless $c->basic_auth(
                $config->{realm} => sub ($login, $pass) {
                    return 0 unless defined $config->{auth}->{$login};
                    return 1 if $config->{auth}->{$login} eq $pass;
                    return 0;
                });
    });
    $r->get('/')->to('firewall#status')->name('status');
    $r->post('/change')->to('firewall#change');
    $r->get('/interfaces')->to('interface#overview')->name('interfaces');
    $r->websocket('/status')->to('interface#status')->name('intf_status');
}

1;
