#!/usr/bin/perl

use utf8;
use strict;
use warnings;

use JSON::XS;
use HTTP::Request;
use LWP::UserAgent;

binmode STDOUT, ":encoding(UTF-8)";

my $sendto_room = shift @ARGV;
utf8::decode($sendto_room);
my $sendto_key = shift @ARGV;
utf8::decode($sendto_key);
my $sendto_token = shift @ARGV;
utf8::decode($sendto_token);
my $subject = shift @ARGV;
utf8::decode($subject);
my $msg = shift @ARGV;
utf8::decode($msg);

my $sendto = "https://chat.googleapis.com/v1/spaces/$sendto_room/messages?key=$sendto_key&token=$sendto_token";

my $status;
my $severity;
my $att = {};

foreach (split("\n", $msg)) {
    ($att->{title}) = m/Trigger: (.*)/ if not defined $att->{title};
    ($status) = m/Trigger status: (.*)/ if not defined $status;
    ($severity) = m/Trigger severity: (.*)/ if not defined $severity;
    ($att->{title_link}) = m/Trigger URL: (.*)/ if not defined $att->{title_link};
}

my $color = undef;
$color = '#97AAB3' if defined $severity and $severity =~ /Not classified/;
$color = '#7499FF' if defined $severity and $severity =~ /Information/;
$color = '#FFC859' if defined $severity and $severity =~ /Warning/;
$color = '#FFA059' if defined $severity and $severity =~ /Average/;
$color = '#E97659' if defined $severity and $severity =~ /High/;
$color = '#E45959' if defined $severity and $severity =~ /Disaster/;
$color = '#00CC00' if defined $status and $status =~ /OK/;

$att->{color} = $color if defined $color;
$att->{text} = $msg if defined $att->{title};

map { delete $att->{$_} if not $att->{$_} } keys %$att;

my $data = {
    cards => [
        {
            header => {
                title => "$subject",
            },
            sections => [
                {
                    widgets => [
                        {
                            keyValue => {
                                topLabel => "Severity",
                                content => "$severity",
                                button => {
                                    textButton => {
                                        text => "Open in Zabbix",
                                        onClick => {
                                            openLink => {
                                                url => $att->{title_link},
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        {
                            textParagraph => {
                                text => $att->{title},
                            }
                        },
                    ],
                },
            ],
        },
    ],
};

my $json = encode_json $data;

print $json."\n";

my $req = HTTP::Request->new(POST => $sendto);
$req->content_type('application/json; charset=UTF-8');
$req->content($json);

my $ua = LWP::UserAgent->new;
my $res = $ua->request($req);

die $res->status_line unless $res->is_success;
