package S2::FW::Plugin::Iftop;
use Mojo::Base 'Mojolicious::Plugin', -signatures;

sub register ($self, $app, @params) {
    $app->helper(query_interfaces => sub ($c) {
            my $result;
            my $interfaces = $c->config->{interfaces};
            foreach my $record (@$interfaces) {
                my $interface = $record->{interface};
                my $sample    = $record->{sample_rate} // 5;
                my $status    = qx(/usr/sbin/iftop -t -i $interface -s $sample 2>&1);
                push @$result, {
                    interface => $record->{interface},
                    label     => $record->{label},
                    status    => $status,
                };
            }
            return $result;
    });
}

1;
