/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.util;

import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class AssertUtils {
    public static void isTrue(boolean expression, @NonNull String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notBlank(@Nullable String str, @NonNull String message) {
        if (str == null) {
            throw new NullPointerException(message);
        }
        if (str.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return;
        }
        throw new IllegalArgumentException(message);
    }

    public static <T> void notEmpty(@Nullable Collection<T> collection, @NonNull String message) {
        if (collection == null) {
            throw new NullPointerException(message);
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> void notEmpty(@Nullable T[] array, @NonNull String message) {
        if (array == null) {
            throw new NullPointerException(message);
        }
        if (array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(@Nullable String str, @NonNull String message) {
        if (str == null) {
            throw new NullPointerException(message);
        }
        if (str.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(@Nullable Object object, @NonNull String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
    }

    private AssertUtils() {
        throw new AssertionError((Object)"Utility class must not be instantiated");
    }
}

