/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.cli;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jodconverter.cli.CliConverter;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.document.JsonDocumentFormatRegistry;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.OfficeUtils;
import org.jodconverter.core.util.FileUtils;
import org.jodconverter.local.LocalConverter;
import org.jodconverter.local.filter.FilterChain;
import org.jodconverter.local.office.ExistingProcessAction;
import org.jodconverter.local.office.LocalOfficeManager;
import org.jodconverter.remote.RemoteConverter;
import org.jodconverter.remote.office.RemoteOfficeManager;
import org.jodconverter.remote.ssl.SslConfig;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public final class Convert {
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR = 2;
    public static final int STATUS_INVALID_ARGUMENTS = 255;
    private static final Option OPT_APPLICATION_CONTEXT = Option.builder((String)"a").longOpt("application-context").argName("file").hasArg().desc("Application context file (optional)").build();
    private static final Option OPT_CONNECTION_URL = Option.builder((String)"c").longOpt("connection-url").argName("url").hasArg().desc("remote LibreOffice Online server URL for conversion").build();
    private static final Option OPT_OUTPUT_DIRECTORY = Option.builder((String)"d").longOpt("output-directory").argName("dir").hasArg().desc("output directory (optional; defaults to input directory)").build();
    private static final Option OPT_OUTPUT_FORMAT = Option.builder((String)"f").longOpt("output-format").hasArg().desc("output format (e.g. pdf)").build();
    private static final Option OPT_HELP = Option.builder((String)"h").longOpt("help").desc("displays help at the command prompt").build();
    private static final Option OPT_OFFICE_HOME = Option.builder((String)"i").longOpt("office-home").argName("dir").hasArg().desc("office home directory (optional; defaults to auto-detect)").build();
    private static final Option OPT_KEEP_ALIVE = Option.builder((String)"k").longOpt("keep-alive").desc("keep the office process alive on shutdown (optional; defaults to false)").build();
    private static final Option OPT_LOAD_PROPERTIES = Option.builder((String)"l").longOpt("load-properties").valueSeparator().hasArgs().desc("load properties (optional; eg. -lPassword=myPassword)").build();
    private static final Option OPT_PROCESS_MANAGER = Option.builder((String)"m").longOpt("process-manager").argName("classname").hasArg().desc("class name of the process manager to use (optional; defaults to auto-detect)").build();
    private static final Option OPT_HOSTNAME = Option.builder((String)"n").longOpt("host-name").hasArg().desc("host name that will be used in the --accept argument when starting a process").build();
    private static final Option OPT_OVERWRITE = Option.builder((String)"o").longOpt("overwrite").desc("overwrite existing output file (optional; defaults to false)").build();
    private static final Option OPT_PORT = Option.builder((String)"p").longOpt("port").hasArg().desc("office socket port (optional; defaults to 2002)").build();
    private static final Option OPT_REGISTRY = Option.builder((String)"r").longOpt("registry").argName("file").hasArg().desc("document formats registry configuration file (optional)").build();
    private static final Option OPT_STORE_PROPERTIES = Option.builder((String)"s").longOpt("store-properties").valueSeparator().hasArgs().desc("store properties (optional; eg. -sOverwrite=true -sFDPageRange=1-2)").build();
    private static final Option OPT_TIMEOUT = Option.builder((String)"t").longOpt("timeout").hasArg().desc("maximum conversion time in seconds (optional; defaults to 120)").build();
    private static final Option OPT_USER_PROFILE = Option.builder((String)"u").longOpt("user-profile").argName("dir").hasArg().desc("use settings from the given user installation dir (optional)").build();
    private static final Option OPT_WORKING_DIR = Option.builder((String)"w").longOpt("working-dir").argName("dir").hasArg().desc("directory where temporary office profile directories will be created (optional; defaults to java.io.tmpdir)").build();
    private static final Option OPT_VERSION = Option.builder((String)"v").longOpt("version").desc("displays version information and exit").build();
    private static final Option OPT_EXISTING_PROCESS_ACTION = Option.builder((String)"x").longOpt("existing-process-action").hasArg().desc("action taken when a process running with the same connection string (optional; defaults to kill); with fail: abort conversion; with kill: kill existing process; with connect: connect to existing process; with connect_or_kill: connect to existing process with kill fallback").build();
    private static final Options OPTIONS = Convert.initOptions();

    private static void checkPrintInfoAndExit(CommandLine commandLine) {
        if (commandLine.hasOption(OPT_HELP.getOpt())) {
            Convert.printHelp();
            System.exit(0);
        }
        if (commandLine.hasOption(OPT_VERSION.getOpt())) {
            Package pack = Convert.class.getPackage();
            Convert.printInfo("jodconverter-cli version %s", pack.getImplementationVersion());
            System.exit(0);
        }
    }

    private static OfficeManager createOfficeManager(CommandLine commandLine, AbstractApplicationContext context) {
        if (commandLine.hasOption(OPT_CONNECTION_URL.getOpt())) {
            return Convert.createRemoteOfficeManager(commandLine, context);
        }
        LocalOfficeManager.Builder builder = LocalOfficeManager.builder();
        builder.startFailFast(Boolean.valueOf(true));
        Convert.applyOption(OPT_OFFICE_HOME, commandLine, arg_0 -> ((LocalOfficeManager.Builder)builder).officeHome(arg_0));
        Convert.applyOption(OPT_WORKING_DIR, commandLine, arg_0 -> ((LocalOfficeManager.Builder)builder).workingDir(arg_0));
        Convert.applyOption(OPT_HOSTNAME, commandLine, arg_0 -> ((LocalOfficeManager.Builder)builder).hostName(arg_0));
        Convert.applyOption(OPT_PROCESS_MANAGER, commandLine, arg_0 -> ((LocalOfficeManager.Builder)builder).processManager(arg_0));
        Convert.applyOption(OPT_PORT, commandLine, opt -> builder.portNumbers(new int[]{Integer.parseInt(opt)}));
        Convert.applyOption(OPT_TIMEOUT, commandLine, opt -> (LocalOfficeManager.Builder)builder.taskExecutionTimeout(Long.valueOf(Long.parseLong(opt) * 1000L)));
        Convert.applyOption(OPT_USER_PROFILE, commandLine, arg_0 -> ((LocalOfficeManager.Builder)builder).templateProfileDir(arg_0));
        builder.keepAliveOnShutdown(Boolean.valueOf(commandLine.hasOption(OPT_KEEP_ALIVE.getOpt())));
        Convert.applyOption(OPT_EXISTING_PROCESS_ACTION, commandLine, opt -> {
            switch (opt.toLowerCase(Locale.ROOT).replace('-', '_')) {
                case "fail": {
                    return builder.existingProcessAction(ExistingProcessAction.FAIL);
                }
                case "kill": {
                    return builder.existingProcessAction(ExistingProcessAction.KILL);
                }
                case "connect": {
                    return builder.existingProcessAction(ExistingProcessAction.CONNECT);
                }
                case "connect_or_kill": {
                    return builder.existingProcessAction(ExistingProcessAction.CONNECT_OR_KILL);
                }
            }
            return builder.existingProcessAction(LocalOfficeManager.DEFAULT_EXISTING_PROCESS_ACTION);
        });
        return ((LocalOfficeManager.Builder)builder.install()).build();
    }

    private static void applyOption(Option option, CommandLine commandLine, Function<String, LocalOfficeManager.Builder> fn) {
        if (commandLine.hasOption(option.getOpt())) {
            fn.apply(commandLine.getOptionValue(option.getOpt()));
        }
    }

    private static OfficeManager createRemoteOfficeManager(CommandLine commandLine, AbstractApplicationContext context) {
        String connectionUrl = Convert.getStringOption(commandLine, OPT_CONNECTION_URL.getOpt());
        assert (connectionUrl != null);
        return RemoteOfficeManager.builder().urlConnection(connectionUrl).sslConfig(context == null ? null : (SslConfig)context.getBean(SslConfig.class)).build();
    }

    private static AbstractApplicationContext getApplicationContextOption(CommandLine commandLine) {
        if (commandLine.hasOption(OPT_APPLICATION_CONTEXT.getOpt())) {
            return new FileSystemXmlApplicationContext(commandLine.getOptionValue(OPT_APPLICATION_CONTEXT.getOpt()));
        }
        return null;
    }

    private static FilterChain getFilterChain(ApplicationContext context) {
        return Optional.ofNullable(context).map(ctx -> (FilterChain)ctx.getBean(FilterChain.class)).orElse(null);
    }

    private static DocumentFormatRegistry getRegistryOption(CommandLine commandLine) throws IOException {
        if (commandLine.hasOption(OPT_REGISTRY.getOpt())) {
            return JsonDocumentFormatRegistry.create((String)FileUtils.readFileToString((File)new File(commandLine.getOptionValue(OPT_REGISTRY.getOpt())), (Charset)StandardCharsets.UTF_8));
        }
        return null;
    }

    private static String getStringOption(CommandLine commandLine, String option) {
        if (commandLine.hasOption(option)) {
            return commandLine.getOptionValue(option);
        }
        return null;
    }

    private static Options initOptions() {
        Options options = new Options();
        options.addOption(OPT_APPLICATION_CONTEXT);
        options.addOption(OPT_CONNECTION_URL);
        options.addOption(OPT_OUTPUT_DIRECTORY);
        options.addOption(OPT_OUTPUT_FORMAT);
        options.addOption(OPT_HELP);
        options.addOption(OPT_OFFICE_HOME);
        options.addOption(OPT_KEEP_ALIVE);
        options.addOption(OPT_LOAD_PROPERTIES);
        options.addOption(OPT_PROCESS_MANAGER);
        options.addOption(OPT_HOSTNAME);
        options.addOption(OPT_OVERWRITE);
        options.addOption(OPT_PORT);
        options.addOption(OPT_REGISTRY);
        options.addOption(OPT_STORE_PROPERTIES);
        options.addOption(OPT_TIMEOUT);
        options.addOption(OPT_USER_PROFILE);
        options.addOption(OPT_VERSION);
        options.addOption(OPT_WORKING_DIR);
        options.addOption(OPT_EXISTING_PROCESS_ACTION);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arguments) {
        try {
            CommandLine commandLine = new DefaultParser().parse(OPTIONS, arguments);
            Convert.checkPrintInfoAndExit(commandLine);
            String outputFormat = Convert.getStringOption(commandLine, OPT_OUTPUT_FORMAT.getOpt());
            String outputDirPath = Convert.getStringOption(commandLine, OPT_OUTPUT_DIRECTORY.getOpt());
            DocumentFormatRegistry registry = Convert.getRegistryOption(commandLine);
            boolean overwrite = commandLine.hasOption(OPT_OVERWRITE.getOpt());
            String[] filenames = commandLine.getArgs();
            if (outputFormat == null && filenames.length % 2 != 0 || filenames.length == 0) {
                Convert.printHelp();
                System.exit(255);
            }
            AbstractApplicationContext context = Convert.getApplicationContextOption(commandLine);
            OfficeManager officeManager = Convert.createOfficeManager(commandLine, context);
            try {
                Convert.printInfo("Starting office", new Object[0]);
                officeManager.start();
                CliConverter converter = Convert.createCliConverter(commandLine, context, officeManager, registry);
                if (outputFormat == null) {
                    String[] inputFilenames = new String[filenames.length / 2];
                    String[] outputFilenames = new String[inputFilenames.length];
                    int i = 0;
                    int j = 0;
                    while (i < filenames.length) {
                        inputFilenames[j] = filenames[i];
                        outputFilenames[j] = filenames[i + 1];
                        i += 2;
                        ++j;
                    }
                    converter.convert(inputFilenames, outputFilenames, outputDirPath, overwrite);
                } else {
                    converter.convert(filenames, outputFormat, outputDirPath, overwrite);
                }
            }
            finally {
                Convert.printInfo("Stopping office", new Object[0]);
                OfficeUtils.stopQuietly((OfficeManager)officeManager);
                if (context != null) {
                    context.close();
                }
            }
            System.exit(0);
        }
        catch (ParseException e) {
            Convert.printErr(e.getMessage());
            Convert.printHelp();
            System.exit(2);
        }
        catch (Exception e) {
            Convert.printErr(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(2);
        }
    }

    private static Map<String, Object> toMap(String ... options) {
        if (options.length % 2 != 0) {
            return new HashMap<String, Object>();
        }
        return IntStream.range(0, options.length).filter(i -> i % 2 == 0).boxed().collect(Collectors.toMap((? super T i) -> options[i], (? super T i) -> {
            String val = options[i + 1];
            if ("true".equalsIgnoreCase(val)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(val)) {
                return Boolean.FALSE;
            }
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                return val;
            }
        }));
    }

    private static Map<String, Object> buildProperties(String ... args) {
        if (args == null || args.length == 0) {
            return new HashMap<String, Object>();
        }
        Map<String, Object> argsMap = Convert.toMap(args);
        if (argsMap.isEmpty()) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, Object> filterDataProperties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : argsMap.entrySet()) {
            String key = entry.getKey();
            if (key.length() > 2 && key.startsWith("FD")) {
                filterDataProperties.put(key.substring("FD".length()), entry.getValue());
                continue;
            }
            properties.put(key, entry.getValue());
        }
        if (!filterDataProperties.isEmpty()) {
            properties.put("FilterData", filterDataProperties);
        }
        return properties;
    }

    private static CliConverter createCliConverter(CommandLine commandLine, AbstractApplicationContext context, OfficeManager officeManager, DocumentFormatRegistry registry) {
        if (commandLine.hasOption(OPT_CONNECTION_URL.getOpt())) {
            RemoteConverter.Builder builder = (RemoteConverter.Builder)RemoteConverter.builder().officeManager(officeManager);
            if (registry != null) {
                builder.formatRegistry(registry);
            }
            return new CliConverter((DocumentConverter)builder.build());
        }
        LocalConverter.Builder builder = (LocalConverter.Builder)LocalConverter.builder().officeManager(officeManager);
        if (registry != null) {
            builder.formatRegistry(registry);
        }
        Map<String, Object> loadProperties = Convert.buildProperties(commandLine.getOptionValues(OPT_LOAD_PROPERTIES.getOpt()));
        builder.loadProperties(loadProperties);
        Map<String, Object> storeProperties = Convert.buildProperties(commandLine.getOptionValues(OPT_STORE_PROPERTIES.getOpt()));
        builder.storeProperties(storeProperties);
        FilterChain filterChain = Convert.getFilterChain((ApplicationContext)context);
        if (filterChain != null) {
            builder.filterChain(filterChain);
        }
        return new CliConverter((DocumentConverter)builder.build());
    }

    private static void printHelp() {
        CharSequence[] help = new String[]{"jodconverter-cli [options] infile outfile [infile outfile ...]", "  or:", "jodconverter-cli [options] -f output-format infile [infile ...]"};
        new HelpFormatter().printHelp(String.join((CharSequence)"\n", help), OPTIONS);
    }

    private static void printErr(Object ... values) {
        System.err.printf("jodconverter-cli: %s%n", values);
        System.err.flush();
    }

    private static void printInfo(String message, Object ... values) {
        System.out.printf(message + "%n", values);
        System.out.flush();
    }
}

