/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.cli;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.core.util.StringUtils;

public final class CliConverter {
    private final PrintWriter out = new PrintWriter(System.out);
    private final DocumentConverter converter;

    public CliConverter(DocumentConverter converter) {
        this.converter = converter;
    }

    public void convert(String[] filenames, String outputFormat, String outputDirPath, boolean overwrite) throws OfficeException {
        AssertUtils.notEmpty((Object[])filenames, (String)"filenames must not be null nor empty");
        AssertUtils.notEmpty((String)outputFormat, (String)"outputFormat must not be null nor empty");
        File outputDir = outputDirPath == null ? null : new File(outputDirPath);
        this.prepareOutputDir(outputDir);
        for (String filename : filenames) {
            File inputFile = new File(filename);
            if (inputFile.isFile()) {
                this.convertFile(inputFile, outputDir == null ? inputFile.getParentFile() : outputDir, FilenameUtils.getBaseName((String)inputFile.getName()) + "." + outputFormat, overwrite);
                continue;
            }
            File inputFileParent = inputFile.getParentFile();
            if (inputFileParent.isDirectory()) {
                this.convertFiles(inputFileParent, filename, outputDir, outputFormat, overwrite);
                continue;
            }
            this.printInfo("Skipping filename '%s' since it doesn't match an existing file...", inputFile);
        }
    }

    public void convert(String[] inputFilenames, String[] outputFilenames, String outputDirPath, boolean overwrite) throws OfficeException {
        AssertUtils.notEmpty((Object[])inputFilenames, (String)"inputFilenames must not be null nor empty");
        AssertUtils.notEmpty((Object[])outputFilenames, (String)"outputFilenames must not be null nor empty");
        int inputLength = inputFilenames.length;
        int outputLength = outputFilenames.length;
        AssertUtils.isTrue((inputLength == outputLength ? 1 : 0) != 0, (String)String.format("input filenames array length [%d] and output filenames array length [%d] don't match", inputLength, outputLength));
        File outputDir = outputDirPath == null ? null : new File(outputDirPath);
        this.prepareOutputDir(outputDir);
        for (int i = 0; i < inputFilenames.length; ++i) {
            String inputFilename = inputFilenames[i];
            String inputFullPath = FilenameUtils.getFullPath((String)inputFilename);
            String outputFilename = outputFilenames[i];
            String outputFullPath = FilenameUtils.getFullPath((String)outputFilename);
            File outputDirectory = StringUtils.isBlank((String)outputFullPath) ? (outputDir == null ? (StringUtils.isBlank((String)inputFullPath) ? new File(".") : new File(inputFullPath)) : outputDir) : new File(outputFullPath);
            this.convertFile(new File(inputFilename), outputDirectory, FilenameUtils.getName((String)outputFilename), overwrite);
        }
    }

    private void convert(File inputFile, File outputFile) throws OfficeException {
        this.printInfo("Converting '%s' to '%s'", inputFile, outputFile);
        this.converter.convert(inputFile).to(outputFile).execute();
    }

    private void convertFile(File inputFile, File outputDir, String outputFilename, boolean overwrite) throws OfficeException {
        File outputFile;
        if (this.validateInputFile(inputFile) && this.validateOutputFile(inputFile, outputFile = new File(outputDir, outputFilename), overwrite)) {
            this.convert(inputFile, outputFile);
        }
    }

    private void convertFiles(File inputDir, String filename, File outputDir, String outputFormat, boolean overwrite) throws OfficeException {
        String wildcard = FilenameUtils.getBaseName((String)filename);
        File[] files = inputDir.listFiles((FileFilter)WildcardFileFilter.builder().setWildcards(new String[]{wildcard}).setIoCase(IOCase.INSENSITIVE).get());
        if (files != null) {
            for (File file : files) {
                this.convertFile(file, outputDir == null ? inputDir : outputDir, FilenameUtils.getBaseName((String)file.getName()) + "." + outputFormat, overwrite);
            }
        }
    }

    private void prepareOutputDir(File outputDir) throws OfficeException {
        if (outputDir != null) {
            try {
                if (outputDir.exists()) {
                    if (outputDir.isFile()) {
                        throw new IOException("Invalid output directory '" + outputDir + "' that exists but is a file");
                    }
                    if (!outputDir.canWrite()) {
                        throw new IOException("Invalid output directory '" + outputDir + "' that cannot be written to");
                    }
                } else {
                    outputDir.mkdirs();
                }
            }
            catch (IOException ex) {
                throw new OfficeException("Could not prepare the output directory", (Throwable)ex);
            }
        }
    }

    private void printInfo(String message, Object ... values) {
        this.out.println(String.format(message, values));
        this.out.flush();
    }

    private boolean validateInputFile(File inputFile) {
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                this.printInfo("Skipping file '%s' that exists but is a directory", inputFile);
                return false;
            }
            if (!inputFile.canRead()) {
                this.printInfo("Skipping file '%s' that cannot be read", inputFile);
                return false;
            }
        } else {
            this.printInfo("Skipping file '%s' that does not exist", inputFile);
            return false;
        }
        return true;
    }

    private boolean validateOutputFile(File inputFile, File outputFile, boolean overwrite) {
        if (outputFile.exists()) {
            if (outputFile.isDirectory()) {
                this.printInfo("Skipping file '%s' because the output file '%s' already exists and is a directory", inputFile, outputFile);
                return false;
            }
            if (!overwrite) {
                this.printInfo("Skipping file '%s' because the output file '%s' already exists and the overwrite switch is off", inputFile, outputFile);
                return false;
            }
            if (!outputFile.delete()) {
                this.printInfo("Skipping file '%s' because the output file '%s' already exists and cannot be deleted", inputFile, outputFile);
                return false;
            }
        }
        return true;
    }
}

