package S2::FW::Plugin::BasicAuth;
use Mojo::Base 'Mojolicious::Plugin', -signatures;

sub register ($self, $app, @params) {
    push @{$app->renderer->classes}, __PACKAGE__;

    $app->renderer->add_helper(
        basic_auth => sub ($c, $realm, $callback) {
            my $auth = $c->req->url->to_abs->userinfo || '';
            return $self->_unauthorized($c, $realm) if not $auth or not $callback;
            return 1                                if $callback and $callback->(split /:/, $auth, 2);
            return $self->_unauthorized($c, $realm);
        });
}

sub _unauthorized ($self, $c, $realm) {
    $c->res->code(401);
    $c->res->headers->www_authenticate("Basic realm=\"$realm\"");
    $c->respond_to(
        json => {json     => {error => 'HTTP 401: Unauthorized'}},
        html => {template => 'auth/basic'},
        any  => {data     => 'HTTP 401: Unauthorized'},
    );
    $c->rendered if $c->tx;
    return;
}

1;
__DATA__

@@ auth/basic.html.ep
<h1>Authorization Required</h1>
<p>This server could not verify that you
are authorized to access the document
requested.  Either you supplied the wrong
credentials (e.g., bad password), or your
browser doesn't understand how to supply
the credentials required.</p>
__END__
