package S2::FW::Command::default;
use Mojo::Base 'Mojolicious::Command', -signatures;

use S2::FW::Controller::Firewall;

has description => 'Apply default mode unless skip reset is set';
has usage       => "Usage: APPLICATION default\n";

sub run ($self) {
    my $c    = $self->app->build_controller(S2::FW::Controller::Firewall->new);
    my $rows = $c->query_nft;
    my @cmd;
    foreach my $row (@$rows) {
        next if defined $row->{skip_reset} and $row->{skip_reset};
        push @cmd, $c->prepare_nft($row, $row->{default} // 'blocked');
    }

    $c->log->debug('nft ' . join('; ', @cmd));
    $c->log->info('NFTables: restoring defaults');
    exec '/usr/sbin/nft', join('; ', @cmd);
}

1;
