#!/bin/bash

proto=https

while getopts "deip:v" arg; do
	case "$arg" in
		d)
			detail=1
			;;
		e)
			expiry=1
			;;
		i)
			issuer=1
			;;
		p)
			proto=$OPTARG
			;;
		v)
			verbose=1
			;;
	esac
done

shift $((OPTIND-1))

host=$1
port=443
tls=

case "$proto" in
	https)
		;;
	smtp)
		port=25
		tls='-starttls smtp'
		;;
	*)
		echo "Unknown protocol $proto" >&2
		exit 1
		;;
esac

get_info() {
	[ -n "$verbose" ] && echo "Connecting to $host:$port ($proto)" >&2
	openssl s_client -servername "$host" -host "$host" -port "$port" -showcerts $tls -prexit </dev/null 2>/dev/null | \
	sed -n '/BEGIN CERTIFICATE/,/END CERT/p' | \
	openssl x509 -text 2>/dev/null
}

if [ -n "$detail" ]; then
	get_info
fi

if [ -n "$expiry" ]; then
	end_date=$(date +%s --date "$(get_info | sed -n 's/\s*Not After\s*:\s*\(.*GMT\)/\1/p')")
	now_date=$(date +%s)
	echo $(( (end_date - now_date) / (24*3600) ))
fi

if [ -n "$issuer" ]; then
	get_info | sed -n 's/\s*Issuer:.*CN\s*=\s*\([^,]\+\)/\1/p'
fi

exit 0
