#!/usr/bin/perl

use utf8;
use strict;
use warnings;

use JSON::XS;

binmode STDOUT, ":encoding(UTF-8)";

my $subject = shift @ARGV;
utf8::decode($subject);
my $msg = shift @ARGV;
utf8::decode($msg);

my $status;
my $severity;
my $att = {};

foreach (split("\n", $msg)) {
    ($att->{title}) = m/Trigger: (.*)/ if not defined $att->{title};
    ($status) = m/Trigger status: (.*)/ if not defined $status;
    ($severity) = m/Trigger severity: (.*)/ if not defined $severity;
    ($att->{title_link}) = m/Trigger URL: (.*)/ if not defined $att->{title_link};
}

my $color = undef;
$color = '#97AAB3' if defined $severity and $severity =~ /Not classified/;
$color = '#7499FF' if defined $severity and $severity =~ /Information/;
$color = '#FFC859' if defined $severity and $severity =~ /Warning/;
$color = '#FFA059' if defined $severity and $severity =~ /Average/;
$color = '#E97659' if defined $severity and $severity =~ /High/;
$color = '#E45959' if defined $severity and $severity =~ /Disaster/;
$color = '#00CC00' if defined $status and $status =~ /OK/;

$att->{color} = $color if defined $color;
$att->{text} = $msg if defined $att->{title};

map { delete $att->{$_} if not $att->{$_} } keys %$att;

my $data = {
    username => "Zabbix",
    text => "$subject: $msg",
};

$data->{text} = $subject if defined $att->{title};
$data->{attachments} = [$att] if defined $att->{title};

my $json = encode_json $data;

`curl -s -X POST -H 'Content-Type: application/json' --data '$json' https://chat.amagical.net/hooks/bWKQmp6fhppcEkERa/C7TnkxBzFFaoioocg9jAKrh2NedTruuqDppxmdqhQ9BEMGCY`;
