package S2::FW::Command::init;
use Mojo::Base 'Mojolicious::Command';

use S2::FW::Controller::Firewall;

has description => 'Initialize everything to default mode';
has usage       => "Usage: APPLICATION init\n";

sub run {
    my $self = shift;

    my $c = $self->app->build_controller(S2::FW::Controller::Firewall->new);
    my $rows = $c->query_nft;
    my @cmd;
    foreach my $row (@$rows) {
        push @cmd, $c->prepare_nft($row, $row->{default} // 'blocked');
    }

    $c->log->debug("nft " . join('; ', @cmd));
    $c->log->info("NFTables: init to defaults");
    exec '/usr/sbin/nft', join('; ', @cmd);
}

1;
