package S2::FW::Controller::Interface;
use Mojo::Base 'Mojolicious::Controller', -signatures;

use Mojo::IOLoop;

sub overview($self) {
    my $data = $self->config->{interfaces};
    return $self->render(rows => $data);
}

sub status($self) {
    $self->inactivity_timeout(300);

    $self->app->log->debug('WebSocket opened');

    Mojo::IOLoop->subprocess->run_p(sub {
        return $self->query_interfaces;
    })->then(sub ($data) {
        $self->send({json => $data});
        $self->finish;
    })->catch(sub ($err) {
        $self->app->log->error("Subprocess error: $err");
    });

    $self->on(finish => sub ($c, $code, $reason = undef) {
        $c->app->log->debug("WebSocket closed with status $code");
    });
}

1;
