# Firewall WebUI

## Mode Switching

We recognize 3 states:
* blocked -- no output traffic allowed
* web -- only a collection of ports is allowed
* admin -- all output traffic allowed, some input ports forwarded to the host

`nft add element s2fw host_mode { 192.168.0.2 : drop }`
`nft add element s2fw host_mode { 192.168.0.3 : jump web }`
`nft add element s2fw host_mode { 192.168.0.4 : accept }`
`nft add element s2fw port_to_ip { 6020-6028 : 192.168.0.2 }`

```
table ip s2fw {
	map host_mode {
		type ipv4_addr : verdict
	}
	map port_to_ip {
		type inet_service : ipv4_addr
		flags interval
	}
	chain forward {
		type filter hook forward priority 0
		ip saddr vmap @host_mode;
	}
	chain input {
		type filter hook input priority 0
		ip saddr vmap @host_mode;
		tcp dport 6020-6028 accept
		udp dport 6020-6028 accept
	}
	chain web {
		tcp dport { 80, 443, 5222, 5223, 5900 } accept
		udp dport { 53 } accept
	}
	chain nat {
		type nat hook prerouting priority -100
		dnat tcp dport map @port_to_ip
		dnat udp dport map @port_to_ip
	}
}

```

## Line Switching

Main line is connected via Tmobile in the default routing table, Lambda line is configured in table 15. Lookup via lambda table is done by routing rule, packets with mark 1 are routed via table 15.

`nft add element s2fw lambda_hosts { 192.168.0.2 }`

```
table ip s2fw {
	set lambda_hosts {
		type ipv4_addr
	}
	chain line {
		type filter hook prerouting priority -150
		ip saddr @lamba_hosts meta mark set 0x1
	}
}
```
