package S2::FW::Plugin::NFT;
use Mojo::Base 'Mojolicious::Plugin';

use Mojo::JSON qw/decode_json/;
use Storable qw/dclone/;

sub register {
    my ($self, $app) = @_;

    $app->helper(query_nft => sub {
            my ($c) = @_;

            my $rows = dclone $c->config->{rows};

            my $nf = decode_json qx(/usr/sbin/nft -j list table s2fw || echo '{"nftables":[{"map":{"name":"host_mode"}},{"set":{"name":"lambda_hosts"}}]}');
            my $host_mode    = (grep { defined $_->{map} and $_->{map}->{name} eq 'host_mode' } @{$nf->{nftables}})[0]->{map}->{elem} // [];
            my $lambda_hosts = (grep { defined $_->{set} and $_->{set}->{name} eq 'lambda_hosts' } @{$nf->{nftables}})[0]->{set}->{elem} // [];

            foreach my $row (@$rows) {
                $row->{current_status} = [];
                my $mode = (grep { $_->[0] eq $row->{ip} } @{$host_mode})[0];
                push @{$row->{current_status}}, 'unknown' unless $mode;
                push @{$row->{current_status}}, 'admin' if exists $mode->[1]->{accept};
                push @{$row->{current_status}}, 'web' if exists $mode->[1]->{jump} and $mode->[1]->{jump} eq 'web';
                push @{$row->{current_status}}, 'blocked' if exists $mode->[1]->{drop};
                push @{$row->{current_status}}, (grep { $_ eq $row->{ip} } @{$lambda_hosts}) ? 'lambda' : 'tmobile';
            }

            return $rows;
        });

    $app->helper(prepare_nft => sub {
            my ($c, $row, $new_mode) = @_;

            my @cmd;
            if ($new_mode eq 'lambda') {
                push @cmd, "add element s2fw lambda_hosts { $row->{ip} }" if grep { /tmobile/i } @{$row->{current_status}};
            }
            elsif ($new_mode eq 'tmobile') {
                push @cmd, "delete element s2fw lambda_hosts { $row->{ip} }" if grep { /lambda/i } @{$row->{current_status}};
            }
            elsif ($new_mode eq 'admin') {
                push @cmd, "delete element s2fw host_mode { $row->{ip} }" unless grep { /unknown/i } @{$row->{current_status}};
                push @cmd, "add element s2fw host_mode { $row->{ip} : accept }";
                push @cmd, "add element s2fw port_to_ip { $row->{port_range}->[0]-$row->{port_range}->[1] : $row->{ip} }";
                push @cmd, "add element s2fw port_to_open { $row->{port_range}->[0]-$row->{port_range}->[1] }";
            }
            elsif ($new_mode eq 'web') {
                push @cmd, "delete element s2fw host_mode { $row->{ip} }" unless grep { /unknown/i } @{$row->{current_status}};
                push @cmd, "add element s2fw host_mode { $row->{ip} : jump web }";
                push @cmd, "delete element s2fw port_to_ip { $row->{port_range}->[0]-$row->{port_range}->[1] }" if grep { /admin/i } @{$row->{current_status}};
                push @cmd, "delete element s2fw port_to_open { $row->{port_range}->[0]-$row->{port_range}->[1] }" if grep { /admin/i } @{$row->{current_status}};
            }
            elsif ($new_mode eq 'blocked') {
                push @cmd, "delete element s2fw host_mode { $row->{ip} }" unless grep { /unknown/i } @{$row->{current_status}};
                push @cmd, "add element s2fw host_mode { $row->{ip} : drop }";
                push @cmd, "delete element s2fw port_to_ip { $row->{port_range}->[0]-$row->{port_range}->[1] }" if grep { /admin/i } @{$row->{current_status}};
                push @cmd, "delete element s2fw port_to_open { $row->{port_range}->[0]-$row->{port_range}->[1] }" if grep { /admin/i } @{$row->{current_status}};
            }
            return @cmd;
        });
}

1;
