package S2::FW::Controller::Firewall;
use Mojo::Base 'Mojolicious::Controller';

use Mojo::IOLoop::Subprocess;

sub status {
    my $self = shift;
    return $self->render(rows => $self->query_nft);
}

sub change {
    my $self = shift;

    my $ip = $self->param('ip');
    my $new_mode = $self->param('mode');
    return $self->render(text => 'Bad Request', status => 400) unless $ip and $new_mode;

    my @rows = grep { $_->{ip} eq $ip } @{$self->query_nft};
    return $self->render(text => 'Bad Request', status => 400) unless @rows == 1;
    my $row = $rows[0];

    return $self->render(text => 'OK', status => 200) if grep { /$new_mode/i } @{$row->{current_status}};

    my @cmd = $self->prepare_nft($row, $new_mode);

    my $subprocess = Mojo::IOLoop::Subprocess->new;
    $subprocess->run(
        sub {
            my $process = shift;
            $self->log->info("NFTables: $ip → $new_mode");
            $self->log->debug("nft " . join('; ', @cmd));
            exec '/usr/sbin/nft', join('; ', @cmd);
        },
        sub {
            my ($process, $err, @results) = @_;
            return $self->render(text => 'OK', status => 200);
        });
    return $self->render_later;
}

1;
