package S2::FW;
use Mojo::Base 'Mojolicious';

use Mojo::File qw/curfile/;
use Mojo::Home;
use Mojolicious::Plugin::HttpBasicAuth;
use S2::FW::Plugin::Iftop;
use S2::FW::Plugin::NFT;

our $VERSION = '0.9';

sub startup {
  my $self = shift;

  $self->moniker('s2fw');
  my $conffile = '/etc/' . $self->moniker . '.conf';
  my $config = $self->plugin('Config',
    file => -e $conffile ? $conffile : undef
  );

  $self->home(Mojo::Home->new(curfile->sibling('FW')));
  $self->static->paths->[0] = $self->home->child('public');
  $self->renderer->paths->[0] = $self->home->child('templates');

  $self->secrets($config->{secrets});
  $self->commands->namespaces(['Mojolicious::Command', 'S2::FW::Command']);

  $self->plugin('http_basic_auth', {
          validate => sub {
              my ($c, $login, $pass, $realm) = @_;
              return 1 if defined $config->{auth}->{$realm}->{$login} and $config->{auth}->{$realm}->{$login} eq $pass;
              return 0;
          },
          realm => $config->{realm},
      });
  $self->plugin('S2::FW::Plugin::Iftop');
  $self->plugin('S2::FW::Plugin::NFT');

  my $r = $self->routes->under(sub {
          my $self = shift;
          return unless $self->basic_auth;
      });
  $r->get('/')->to('firewall#status')->name('status');
  $r->post('/change')->to('firewall#change');
  $r->get('/interfaces')->to('interface#overview')->name('interfaces');
  $r->websocket('/status')->to('interface#status')->name('intf_status');
}

1;
