/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.remote.office;

import java.io.File;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.office.AbstractOfficeManagerPool;
import org.jodconverter.core.office.InstalledOfficeManagerHolder;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.OfficeUtils;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.remote.office.RemoteOfficeManagerPoolEntry;
import org.jodconverter.remote.ssl.SslConfig;

public final class RemoteOfficeManager
extends AbstractOfficeManagerPool<RemoteOfficeManagerPoolEntry> {
    public static final int DEFAULT_POOL_SIZE = 1;
    public static final int MAX_POOL_SIZE = 1000;
    public static final long DEFAULT_CONNECT_TIMEOUT = 60000L;
    public static final long DEFAULT_SOCKET_TIMEOUT = 120000L;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull RemoteOfficeManager make(@NonNull String urlConnection) {
        return RemoteOfficeManager.builder().urlConnection(urlConnection).build();
    }

    public static @NonNull RemoteOfficeManager install(@NonNull String urlConnection) {
        return ((Builder)RemoteOfficeManager.builder().urlConnection(urlConnection).install()).build();
    }

    private RemoteOfficeManager(int poolSize, File workingDir, String urlConnection, SslConfig sslConfig, long connectTimeout, long socketTimeout, long taskExecutionTimeout, long taskQueueTimeout) {
        super(poolSize, workingDir, taskQueueTimeout);
        this.setEntries(IntStream.range(0, poolSize).mapToObj(i -> new RemoteOfficeManagerPoolEntry(urlConnection, sslConfig, connectTimeout, socketTimeout, taskExecutionTimeout)).collect(Collectors.toList()));
    }

    public static final class Builder
    extends AbstractOfficeManagerPool.AbstractOfficeManagerPoolBuilder<Builder> {
        private int poolSize = 1;
        private String urlConnection;
        private SslConfig sslConfig;
        private long connectTimeout = 60000L;
        private long socketTimeout = 120000L;

        private Builder() {
        }

        public @NonNull RemoteOfficeManager build() {
            AssertUtils.notBlank((String)this.urlConnection, (String)"urlConnection must not be null nor blank");
            OfficeUtils.validateWorkingDir((File)this.workingDir);
            RemoteOfficeManager manager = new RemoteOfficeManager(this.poolSize, this.workingDir, this.urlConnection, this.sslConfig, this.connectTimeout, this.socketTimeout, this.taskExecutionTimeout, this.taskQueueTimeout);
            if (this.install) {
                InstalledOfficeManagerHolder.setInstance((OfficeManager)manager);
            }
            return manager;
        }

        public @NonNull Builder poolSize(@Nullable Integer poolSize) {
            if (poolSize != null) {
                AssertUtils.isTrue((poolSize >= 0 && poolSize <= 1000 ? 1 : 0) != 0, (String)String.format("poolSize %s must be between %d and %d", poolSize, 1, 1000));
                this.poolSize = poolSize;
            }
            return this;
        }

        public @NonNull Builder urlConnection(@Nullable String urlConnection) {
            this.urlConnection = urlConnection;
            return this;
        }

        public @NonNull Builder sslConfig(@Nullable SslConfig sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public @NonNull Builder connectTimeout(@Nullable Long connectTimeout) {
            if (connectTimeout != null) {
                AssertUtils.isTrue((connectTimeout >= 0L ? 1 : 0) != 0, (String)String.format("connectTimeout %s must greater than or equal to 0", connectTimeout));
                this.connectTimeout = connectTimeout;
            }
            return this;
        }

        public @NonNull Builder socketTimeout(@Nullable Long socketTimeout) {
            if (socketTimeout != null) {
                AssertUtils.isTrue((socketTimeout >= 0L ? 1 : 0) != 0, (String)String.format("socketTimeout %s must greater than or equal to 0", socketTimeout));
                this.socketTimeout = socketTimeout;
            }
            return this;
        }
    }
}

